/*
 * @(#)ZipSelectedAddFile.java	1.0 98/12/11
 *
 * Java Project performed by
 *     Frank Moisant
 *    Patrick Titiano
 *        (ITRA3)
 *
 */


import com.sun.java.swing.JDialog;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.ScrollPaneConstants;
import com.sun.java.swing.JButton;
import com.sun.java.swing.event.TableModelEvent;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JCheckBox;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import java.awt.Frame;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Dimension;
import java.awt.Point;


import java.io.File;
import java.io.IOException;

import java.util.Vector;


/**
 * Class used to select file to add in the current archive
 * @see ZipTable
 * @see ZipButton
 * @version 1.0
 * @author Frank Moisant - Patrick Titiano
 */ 
public class ZipSelectedAddFile extends JDialog {
    
    // private members
    private JScrollPane scrollPane;
    private ZipTable zipTable;
    private ZipButton upButton;
    private Vector files;
    private String currentDirectory;
    private JComboBox comboBox;
    private JCheckBox checkBox;
    private Vector result;

    // public members
    public int positionInPathName;
    public boolean canceled;

    /**
     * Class constructor
     * @param owner the frame which instanciate the dialog
     */
    public ZipSelectedAddFile(Frame owner) {
	super(owner,"Chose files to archive",true);


	/**
	 * This class is used to activate the closing cross
	 * @version 1.0
	 * @author Frank Moisant - Patrick Titiano
	 */
	addWindowListener(new WindowAdapter() {

	    /**
	     * Use when window is closing
	     * @param e the window event
	     */
	    public void windowClosing(WindowEvent e) {
		zipTable.clearSelection();
		canceled = true;
	    }
	});

	// initialize members
	canceled = false;
	result = new Vector();
	ButtonListener buttonListener = new ButtonListener();
	files = new Vector();
	Vector name = new Vector();
	name.addElement("File list");
	zipTable = new ZipTable(files,name);
	zipTable.addMouseListener(new MouseListener());

	// initilize the drive vector
	Vector Lecteurs = new Vector();
	Lecteurs.addElement("A:"+ File.separator);
	Lecteurs.addElement("B:"+ File.separator);
	Lecteurs.addElement("C:"+ File.separator);
	Lecteurs.addElement("D:"+ File.separator);
	Lecteurs.addElement("E:"+ File.separator);
	Lecteurs.addElement("F:"+ File.separator);
	Lecteurs.addElement("G:"+ File.separator);
	Lecteurs.addElement("H:"+ File.separator);
	Lecteurs.addElement("I:"+ File.separator);
	Lecteurs.addElement("J:"+ File.separator);
	Lecteurs.addElement("K:"+ File.separator);
	Lecteurs.addElement("L:"+ File.separator);
	Lecteurs.addElement("M:"+ File.separator);
	Lecteurs.addElement("N:"+ File.separator);
	Lecteurs.addElement("O:"+ File.separator);
	Lecteurs.addElement("P:"+ File.separator);
	Lecteurs.addElement("Q:"+ File.separator);
	Lecteurs.addElement("R:"+ File.separator);
	Lecteurs.addElement("S:"+ File.separator);
	Lecteurs.addElement("T:"+ File.separator);
	Lecteurs.addElement("U:"+ File.separator);
	Lecteurs.addElement("V:"+ File.separator);
	Lecteurs.addElement("W:"+ File.separator);
	Lecteurs.addElement("X:"+ File.separator);
	Lecteurs.addElement("Y:"+ File.separator);
	Lecteurs.addElement("Z:"+ File.separator);


	// the check box to the recurse directory option
	checkBox = new JCheckBox("Recurse Folder", true);

	// the combo box to choose the drive
	comboBox = new JComboBox(Lecteurs) {
	    public boolean isEditable() {
		return false;
	    }
	};
	comboBox.setMaximumRowCount(3);
	comboBox.setActionCommand("DRIVE");
	comboBox.addActionListener(buttonListener);

	// scrollpane for the table
	scrollPane = new JScrollPane(zipTable, ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
				     ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	scrollPane.setBackground(Color.white);
	scrollPane.setAutoscrolls(true);

	// the button to go to the previous folder
	upButton = new ZipButton("UP","images" + File.separator + "previous.gif");
	upButton.addActionListener(buttonListener);
	upButton.setToolTipText("Parent directory");


	JPanel panelNorth = new JPanel();
	panelNorth.setLayout(new FlowLayout(FlowLayout.LEFT));
	panelNorth.add(new JLabel("Select a drive:"));
	panelNorth.add(comboBox);
	panelNorth.add(upButton);
	panelNorth.add(checkBox);	

	// the ok-cancel buttons
	JPanel panelSouth = new JPanel();
	panelNorth.setLayout(new FlowLayout(FlowLayout.CENTER));
	JButton okButton = new JButton("OK");
	okButton.setActionCommand("OK");
	okButton.addActionListener(buttonListener);
	JButton cancelButton = new JButton("Cancel");
	cancelButton.setActionCommand("CANCEL");
	cancelButton.addActionListener(buttonListener);
	panelSouth.add(okButton);
	panelSouth.add(cancelButton);


	getContentPane().add("North",panelNorth);
	getContentPane().add("Center",scrollPane);
	getContentPane().add("South",panelSouth);

	// prepare and display the dialog
	pack();
	setSize(300,300);
	Dimension dim = owner.getSize();
	Point loc = owner.getLocation();
	Dimension curdim = getSize();
	setLocation(loc.x + dim.width/2 - curdim.width/2, loc.y + dim.height/2 - curdim.height/2);

	// the current path is set
	File directory = new File(".");
	String tmpDir = directory.getAbsolutePath();
	currentDirectory = tmpDir.substring(0,tmpDir.length()-2); // path without \. at the end
	setPath(currentDirectory); // to print the first time
	setVisible(true);
    }

    /**
     * set the path to display
     * @param path the path to display
     */
    public void setPath(String path) {

	// current directory
	File file = new File(path);

	// files in the path
	String tab[] = file.list();

	files.removeAllElements();

	for(int i = 0; i < tab.length; i++) {
	    Vector row = new Vector();
	    String fullname = tab[i];
	    int lastPointIndex = fullname.lastIndexOf(".");
	    String extension;
	    File verifyDir = new File(path + File.separator +  tab[i]);
	    if(verifyDir.isDirectory()) {
		extension = "directory";
	    }
	    else {
		if(lastPointIndex == -1) {
		    extension = "UNKNOWN";
		}
		else {
		    extension = fullname.substring(lastPointIndex+1).toUpperCase();
		}
	    }
	    row.addElement(fullname);
	    row.addElement(extension);

	    files.addElement(row);
	}

	TableModelEvent tme = new TableModelEvent(zipTable.getModel());
	zipTable.tableChanged(tme);
	zipTable.clearSelection();
    }
    

    /**
     * Method calls when the window manager want to resize th Dialog
     * @return always false
     */
    public boolean isResizable() {
	return false;
    }


    /**
     * Internal class implement Action Listener for button and combo box actions
     * @version 1.0
     * @author Frank Moisant - Patrick Titiano
     */
    private class ButtonListener implements ActionListener {

	/**
	 * called when an action on the button or combo box arrive
	 * @param e the action event
	 */
	public void actionPerformed(ActionEvent e) {
	    String theAction = e.getActionCommand();

	    // previous directory
	    if(theAction.equals("UP")) {
		int lastSeparatorIndex = currentDirectory.lastIndexOf(File.separator);
		int firstSeparatorIndex = currentDirectory.indexOf(File.separator);
		if(lastSeparatorIndex == firstSeparatorIndex) {
		    lastSeparatorIndex++;
		}
		currentDirectory = currentDirectory.substring(0,lastSeparatorIndex);

		setPath(currentDirectory);
	    }

	    // new drive selection
	    else if(theAction.equals("DRIVE")) {
		File testDrive = new File((String )comboBox.getSelectedItem());
		if(testDrive.exists()) {
		    currentDirectory = (String )comboBox.getSelectedItem();		
		    setPath(currentDirectory);
		}
	    }

	    // ok action
	    else if(theAction.equals("OK")) {
		setVisible(false);
	    }

	    // cancel action
	    else {
		zipTable.clearSelection();
		canceled = true;
		setVisible(false);
	    }
	}
    }


    /**
     * Class used to listen the mouse action
     * @version 1.0
     * @author Frank Moisant - Patrick Titiano
     */
    private class MouseListener extends MouseAdapter {

	/**
	 * Called when mouse button are clicked
	 * @param e the mouse event
	 */
	public void mouseClicked(MouseEvent e) {

	    // if double click enter in the folder
	    if (e.getClickCount() == 2) {
		int index = zipTable.getSelectedRow();
		if(index != -1) {
		    Vector row = (Vector )files.elementAt(index);
		    String type = (String )row.elementAt(1);
		    if( type.equals("directory") ) {
			int lastSeparatorIndex = currentDirectory.lastIndexOf(File.separator);
			int firstSeparatorIndex = currentDirectory.indexOf(File.separator);
			String separator = File.separator;
			if((lastSeparatorIndex == firstSeparatorIndex)&&
			   (firstSeparatorIndex == currentDirectory.length() -1)) {
			    separator = "";
			}
			currentDirectory = currentDirectory + separator + (String) row.elementAt(0);
			setPath(currentDirectory);
		    }
		    else {
			setVisible(false);
		    }
		}
	    }
	}
    }


    /**
     * Add recurse folder in global variable result
     * @param directory a file to the directory to recurse
     */
    private void setRecurseFilesOf(File directory) {
	String[] theFiles = directory.list();
	for(int i = 0; i<theFiles.length; i++) {
	    File newFile = null;
	    try {
		String canonicalPath = directory.getCanonicalPath();
		newFile = new File(canonicalPath,theFiles[i]);
		if(newFile.isDirectory()) {
		    setRecurseFilesOf(newFile);
		}
		else {
		    result.addElement(newFile.getAbsolutePath());
		}
	    }
	    catch(IOException e) {
		e.printStackTrace();
	    }
	}
    }



    /**
     * Method return the selected files or/and directories
     * @return a vector with the path + file name of all files
     */
    public Vector getSelectedFiles() {
	result.removeAllElements();
	positionInPathName = currentDirectory.length();

	if(zipTable.getSelectedRowCount() != 0) {
	    int[] selectedRows = zipTable.getSelectedRows();
	    for(int i = 0; i < selectedRows.length; i++) {
		Vector tmp = (Vector) files.elementAt(selectedRows[i]);

		int lastSeparatorIndex = currentDirectory.lastIndexOf(File.separator);
		int firstSeparatorIndex = currentDirectory.indexOf(File.separator);
		String separator = File.separator;
		if((lastSeparatorIndex == firstSeparatorIndex)&&
			   (firstSeparatorIndex == currentDirectory.length() -1)) {
		    separator = "";
		}
		String thefile = currentDirectory + separator + (String)tmp.elementAt(0);
		File tmpfile = new File(thefile);
		if(tmpfile.isDirectory()) {
		    if(checkBox.isSelected()) {
			setRecurseFilesOf(tmpfile);
			positionInPathName = thefile.lastIndexOf(File.separator) + 1;
		    }
		}
		else {
		    result.addElement(thefile);
		}
	    }
	    return result;
	}
	else {
	    return result;
	}
    }
}
